/********************************************************************
 FileName:     	Configuration base-pic32mx.h
 Dependencies:  See INCLUDES section
 Processor:     PIC32MX250F128B
 Hardware:      ET-BASE PIC32MX
 Compiler:      Microchip XC32

********************************************************************
 File Description:

 Change History:
  Rev   Date         Description
  1.0   29/09/2013   Initial release 
********************************************************************/

#ifndef CONFIGURATION_ET_BASE_PIC32MX_H
#define CONFIGURATION_ET_BASE_PIC32MX_H

/** CONFIGURATION **************************************************/
#if defined(ET_BASE_PIC32MX)
    #if defined(__32MX250F128B__)

        // DEVCFG3
        // USERID = No Setting
        #pragma config PMDL1WAY = OFF           // Peripheral Module Disable Configuration (Allow multiple reconfigurations)
        #pragma config IOL1WAY = OFF            // Peripheral Pin Select Configuration (Allow multiple reconfigurations)
        #pragma config FUSBIDIO = OFF           // USB USID Selection (Controlled by Port Function)
        #pragma config FVBUSONIO = OFF          // USB VBUS ON Selection (Controlled by Port Function)

        // DEVCFG2
        #pragma config FPLLIDIV = DIV_2         // PLL Input Divider (2x Divider) (Oscillator = 8 MHz)
        #pragma config FPLLMUL = MUL_24         // PLL Multiplier (24x Multiplier)
        #pragma config UPLLIDIV = DIV_2         // USB PLL Input Divider (2x Divider)
        #pragma config UPLLEN = ON              // USB PLL Enable (Enabled)
        #pragma config FPLLODIV = DIV_2         // System PLL Output Clock Divider (PLL Divide by 2)

        // DEVCFG1
        #pragma config FNOSC = PRIPLL           // Oscillator Selection Bits (Primary Osc w/PLL (XT+,HS+,EC+PLL))
        #pragma config FSOSCEN = OFF            // Secondary Oscillator Enable (Disabled)
        #pragma config IESO = OFF               // Internal/External Switch Over (Disabled)
        #pragma config POSCMOD = HS             // Primary Oscillator Configuration (HS osc mode)
        #pragma config OSCIOFNC = OFF           // CLKO Output Signal Active on the OSCO Pin (Disabled)
        #pragma config FPBDIV = DIV_1           // Peripheral Clock Divisor (Pb_Clk is Sys_Clk/1)
        #pragma config FCKSM = CSDCMD           // Clock Switching and Monitor Selection (Clock Switch Disable, FSCM Disabled)
        #pragma config WDTPS = PS1048576        // Watchdog Timer Postscaler (1:1048576)
        #pragma config WINDIS = OFF             // Watchdog Timer Window Enable (Watchdog Timer is in Non-Window Mode)
        #pragma config FWDTEN = OFF             // Watchdog Timer Enable (WDT Disabled (SWDTEN Bit Controls))
        #pragma config FWDTWINSZ = WISZ_25      // Watchdog Timer Window Size (Window Size is 25%)

        // DEVCFG0
        #pragma config JTAGEN = OFF             // JTAG Enable (JTAG Disabled)
        #pragma config ICESEL = ICS_PGx1        // ICE/ICD Comm Channel Select (Communicate on PGEC1/PGED1)
        #pragma config PWP = OFF                // Program Flash Write Protect (Disable)
        #pragma config BWP = OFF                // Boot Flash Write Protect bit (Protection Disabled)
        #pragma config CP = OFF                 // Code Protect (Protection Disabled)
    #else
        #error No hardware board defined, see "HardwareProfile.h" and __FILE__
    #endif
#endif

#endif  //CONFIGURATION_ET_BASE_PIC32MX_H
